/*
	File:		ClassicPane.h

	Contains:	Class to drive our classic pane, showing new versions of old favorites.

	Version:	Appearance 1.0 SDK

	Copyright:	 1997 by Apple Computer, Inc., all rights reserved.

	File Ownership:

		DRI:				Edward Voas

		Other Contact:		7 of 9, Borg Collective

		Technology:			OS Technologies Group

	Writers:

		(edv)	Ed Voas

	Change History (most recent first):

		 <2>	10/28/97	edv		Use RadioGroup control!
		 <1>	 9/11/97	edv		First checked in.
*/

#pragma once

#include "MegaPane.h"
#include "Appearance.h"

class ClassicPane : public MegaPane
{
	public:
			ClassicPane( DialogPtr dialog, SInt16 items );
		virtual ~ClassicPane();
		
		virtual void		ItemHit( SInt16 item );
	
	private:
		static pascal void	ScrollingFeedbackProc( ControlHandle control, SInt16 part );
		static pascal void	DrawPictureProc( ControlHandle control, SInt16 part );

		static ControlActionUPP	fScrollBarProc;
		static ControlUserPaneDrawUPP fDrawProc;

		ControlHandle		fVerticalScrollBar;
		ControlHandle		fHorizontalScrollBar;
		ControlHandle		fUserItem;
		Point				fPictOffset;
		SInt16				fPictWidth;
		SInt16				fPictHeight;
		PicHandle			fPicture;
		SInt16				fUserItemHeight;
		SInt16				fUserItemWidth;
};
